function [minPx maxPx] = falseColorVideo(vidname)
% This function takes in a grey-scale AVI (8-bit) filename and returns the 
% same video shown in heat-map mode, where brighter pixels are red and darker
% pixels are black/blue.

ncolors = 128;
vreader = VideoReader(vidname);
numFrames = vreader.NumberOfFrames;

% Figure out min and max values for use with the automatic heat map
pixels = [];

for i = 1:numFrames  % Check every 
    fr = read(vreader, i);
    fr = unique(fr);
    pixels = unique(cat(1, pixels, fr));
end

minPx = 55
maxPx = 170

%minPx = pixels(ceil(length(pixels)* .4/10));  %  7th percentile
%maxPx = pixels(ceil(length(pixels)* 7/10));   % 60th percentile

cm = genColormap(ncolors);

vwriter = VideoWriter(strcat(vidname(1:end-4), '_hm.avi'), 'Uncompressed AVI');
vwriter.FrameRate = 4; % Speed up video - normally vreader.FrameRate;
open(vwriter);

for i = 1:numFrames
    oldfr = read(vreader, i);
    newfr = oldfr - minPx;   % all things less than minPx will have the lowest color value
    newfr = uint8(double(newfr) ./ double(maxPx-minPx) * ncolors);
    frame.cdata = newfr(:,:,1);
    frame.colormap = cm;
    %if (i >= 10)
         %y1 = 81;
         %y2 = 91;
         %x1 = 85;
         %x2 = 95;
    %     frame.cdata(200:230, 330:360,  1) = 56; 
         %frame.cdata(y1:y2, x1,  1) = 56; 
         %frame.cdata(y1:y2, x2,  1) = 56;
         %frame.cdata(y1, x1:x2,  1) = 56;
         %frame.cdata(y2, x1:x2,  1) = 56;
    %end
    writeVideo(vwriter, frame);
end

close(vwriter);

end